/*
 * Created on 2015/09/04
 * Copyright (C) 2015 Koga Laboratory. All rights reserved.
 *
 */
package problem;

import org.mklab.daej.ivps.AbstractIvpsDifferentialAlgebraicEquation;

public class Pendulum extends AbstractIvpsDifferentialAlgebraicEquation {

  public Pendulum() {
    this.fullnm = "Pendulum";   //　問題名
    this.problm = "pend";       //　問題の略称
    this.type = "DAE";          //　問題の種類
    this.numberOfEquation = 5;  //　方程式の数

    this.numjac = false;        //　ヤコビ行列を定義するか(falseで定義する)
    this.mljac = this.numberOfEquation;     //　ヤコビ行列の下バンド幅
    this.mujac = this.numberOfEquation;     //　ヤコビ行列の上バンド幅
    this.mlmas = this.numberOfEquation;     //　M行列の下バンド幅
    this.mumas = this.numberOfEquation;     //　M行列の上バンド幅

    this.ind = new int[] {1, 1, 2, 2, 3};   //　各変数の指数
    for (int i = 0; i < this.ind.length; i++)
      this.getInd()[i] = this.ind[i];
  }

  /* 初期値、初期微分値の設定 */
  @Override
  public void init(int neqn, double t, double[] y, double[] yprime, boolean[] consis) {
    // 初期値
    y[0] = 1.0;
    y[1] = 0.0;
    y[2] = 0.0;
    y[3] = 1.0;
    y[4] = 1.0;

    //　初期微分値
    yprime[0] = 0.0;
    yprime[1] = 1.0;
    yprime[2] = -1.0;
    yprime[3] = -9.8;
    yprime[4] = 3 * 9.8;

    consis[0] = true;
  }

  /* f(t,x)の記述 */
  @Override
  public void feval(int neqn, double t, double[] y, double[] yprime, double[] f, int[] ierr, double[] rpar, int[] ipar) {
    // f(t,x)
    f[0] = y[2];
    f[1] = y[3];
    f[2] = -y[4] * y[0];
    f[3] = -y[4] * y[1] - 9.8;
    f[4] = y[0] * y[0] + y[1] * y[1] - 1;
  }

  /* ヤコビ行列Jの設定 */
  @Override
  public void jeval(int ldim, int neqn, double t, double[] y, double[] yprime, double[][] dfdy, int[] ierr, double[] rpar, int[] ipar) {
    // ヤコビ行列J
    dfdy[0][2] = 1.0;
    dfdy[1][3] = 1.0;
    dfdy[2][0] = -y[4];
    dfdy[2][4] = -y[0];
    dfdy[3][1] = -y[4];
    dfdy[3][4] = -y[1];
    dfdy[4][0] = 2 * y[0];
    dfdy[4][1] = 2 * y[1];
  }

  /* M行列の設定 */
  @Override
  public void meval(int ldim, int neqn, double t, double[] y, double[] yprime, double[][] dfddy, int[] ierr, double[] rpar, int[] ipar) {
    // M行列
    dfddy[0][0] = 1.0;
    dfddy[1][1] = 1.0;
    dfddy[2][2] = 1.0;
    dfddy[3][3] = 1.0;
  }

  @Override
  public void setTolerances(int neqn, double[] rtol, double[] atol, boolean[] tolvec) {
    //dummy
  }

}
